/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef MX__LIB_H
# define MX__LIB_H

void mx__luigi(struct mx_endpoint *ep);
void mx__nic_id_to_macaddr(uint64_t nic_id, uint8_t macaddr[6]);
void mx__macaddr_to_nic_id(uint8_t macaddr[6], uint64_t *nic_id);
void mx__finish_buffered_requests(struct mx_endpoint *ep);
MX__THREAD_RETURN_T mx__progress_thread(void *p);
union mx_request;
int mx__queue_large_recv(struct mx_endpoint *ep, union mx_request *r);
void mx__post_send(struct mx_endpoint *ep, union mx_request *q,
		   mcp_ureq_t *req, uint16_t mcp_handle);
union mx_request * mx__recv_complete(struct mx_endpoint *ep,
				     union mx_request *r, 
				     mx_status_code_t status);
void mx__send_complete(mx_endpoint_t ep, union mx_request *r,
		       mx_status_code_t status);

mx_return_t mx__isend(struct mx_endpoint * ep,
		      mx_segment_t *segments_list, uint32_t segments_count,
		      uintptr_t pin_type,
		      mx_endpoint_addr_t dest_address, uint64_t match_info,
		      void *context, mx_request_t *request);

void mx_rdmawin_finalize(struct mx_endpoint *ep);
void mx_rdmawin_init(struct mx_endpoint *ep);

struct mx__wait_queue * mx__try_probe(mx_endpoint_t ep, uint32_t ctxid);

void mx__process_early(mx_endpoint_t ep, struct mx__partner *partner);

int mx_check_wait_status(struct mx_endpoint *ep, uint32_t * status);

union mx_request *mx__received_last_frag(mx_endpoint_t ep, union mx_request *r,
					 int from_partial, mx_status_code_t);

int mx__abort_sent_request(struct mx_endpoint * ep, struct mx__partner * partner,
			   union mx_request * req, mx_status_code_t status_code);

MX_FUNC(const char *) mx__nic_id_to_str(char *str, uint64_t nic_id, uint32_t len);

#define MX_RUNTIME_OPT 1

#if MX_RUNTIME_OPT == 0
/* mostly experimental code
    requires perl -i -lpe 's/mx__opt\./mx__opt_/g' *.[ch] 
    and MX_RUNTIME_OPT  == 0
    used to transform runtime options into compile-time options
    to check for performance impact */
static const uint8_t mx__opt.monothread = 1;
static const uint8_t mx__opt.verbose = 0;
static const uint8_t mx__opt.verbose_errors = 0;
static const uint8_t mx__opt.errors_are_fatal = 1;
static const uint8_t mx__opt.sigusr1_handler = 0;
static const uint8_t mx__opt.disable_self = 1;
static const uint8_t mx__opt.disable_shmem = 1;
static const uint8_t mx__opt.rcache = 0;
static const uint8_t mx__opt.coredump = 0;
static const uint8_t mx__opt.abort_sleeps = 0;
static const uint8_t mx__opt.no_myrinet = 0;
static const uint8_t mx__opt.csum = 0;
static const uint8_t mx__opt.wc_fence = 0;
static const uint8_t mx__opt.stats = 0;
static const uint8_t mx__opt.fw_ack = 0;
static const uint8_t mx__opt.pipeline_log = 0;
static const uint8_t mx__opt.zombie_send = 1;
static const uint8_t mx__opt.intel_cpu = 0;

#else
extern struct mx__opt {
  uint8_t monothread;
  uint8_t verbose;
  uint8_t verbose_errors;
  uint8_t errors_are_fatal;
  uint8_t sigusr1_handler;
  uint8_t disable_self;
  uint8_t disable_shmem;
  uint8_t rcache;
  uint8_t coredump;
  uint8_t abort_sleeps;
  uint8_t no_myrinet;
  uint8_t csum;
  uint8_t wc_fence;
  uint8_t stats;
  uint32_t fw_ack;
  int8_t pipeline_log;
  uint8_t zombie_send;
  uint16_t max_retries;
  uint8_t matter_debug;
  uint8_t intel_cpu;
  uint8_t cpus;
  uint8_t imm_ack;
} mx__opt;
#endif

#endif /* MX_LIB_H */
